# محرر العقود الاحترافي | Professional Contract Editor

## 🎯 **نظام متكامل لتصميم وإدارة العقود**

محرر عقود احترافي مطور بالكامل باستخدام HTML5، CSS3، وJavaScript الحديث. يوفر واجهة مستخدم أنيقة وسهلة الاستخدام لتصميم العقود مع إمكانيات متقدمة للتخصيص والتصدير.

---

## ✨ **الميزات الرئيسية**

### 🎨 **واجهة مستخدم متقدمة**
- تصميم عصري ومتجاوب يعمل على جميع الأجهزة
- دعم كامل للغة العربية مع اتجاه النص الصحيح
- نظام ألوان متناسق وجذاب
- حركات وانتقالات سلسة لتجربة مستخدم ممتازة

### 📝 **محرر تفاعلي قوي**
- محرر WYSIWYG (ما تراه هو ما تحصل عليه)
- نظام السحب والإفلات للمتغيرات والعناصر
- إمكانية التحرير المباشر في المحرر
- دعم العناصر المتنوعة (عناوين، فقرات، جداول، توقيعات)

### 🔧 **81 متغيراً شاملاً**
المتغيرات مقسمة إلى 9 فئات منظمة:

#### 1. **معلومات الشركة (9 متغيرات)**
- `$company_name` - اسم الشركة
- `$company_address` - عنوان الشركة  
- `$company_phone` - هاتف الشركة
- `$company_email` - بريد الشركة الإلكتروني
- `$company_website` - موقع الشركة
- `$company_license` - رخصة الشركة
- `$company_tax_number` - الرقم الضريبي للشركة
- `$company_manager` - مدير الشركة
- `$company_representative` - ممثل الشركة

#### 2. **معلومات العميل (9 متغيرات)**
- `$client_name` - اسم العميل
- `$client_address` - عنوان العميل
- `$client_phone` - هاتف العميل
- `$client_email` - بريد العميل الإلكتروني
- `$client_id_number` - رقم هوية العميل
- `$client_company` - شركة العميل
- `$client_position` - منصب العميل
- `$client_nationality` - جنسية العميل
- `$client_representative` - ممثل العميل

#### 3. **تفاصيل العقد (9 متغيرات)**
- `$contract_number` - رقم العقد
- `$contract_date` - تاريخ العقد
- `$contract_start_date` - تاريخ بداية العقد
- `$contract_end_date` - تاريخ انتهاء العقد
- `$contract_duration` - مدة العقد
- `$contract_type` - نوع العقد
- `$contract_status` - حالة العقد
- `$contract_location` - مكان العقد
- `$contract_language` - لغة العقد

#### 4. **المعلومات المالية (9 متغيرات)**
- `$total_amount` - المبلغ الإجمالي
- `$currency` - العملة
- `$payment_method` - طريقة الدفع
- `$payment_terms` - شروط الدفع
- `$advance_payment` - الدفعة المقدمة
- `$remaining_amount` - المبلغ المتبقي
- `$tax_amount` - مبلغ الضريبة
- `$discount_amount` - مبلغ الخصم
- `$final_amount` - المبلغ النهائي

#### 5. **تفاصيل النقل (9 متغيرات)**
- `$pickup_location` - مكان الاستلام
- `$delivery_location` - مكان التسليم
- `$pickup_date` - تاريخ الاستلام
- `$delivery_date` - تاريخ التسليم
- `$pickup_time` - وقت الاستلام
- `$delivery_time` - وقت التسليم
- `$distance` - المسافة
- `$vehicle_type` - نوع المركبة
- `$driver_name` - اسم السائق

#### 6. **تفاصيل البضائع (9 متغيرات)**
- `$cargo_description` - وصف البضائع
- `$cargo_weight` - وزن البضائع
- `$cargo_volume` - حجم البضائع
- `$cargo_quantity` - كمية البضائع
- `$cargo_value` - قيمة البضائع
- `$cargo_type` - نوع البضائع
- `$packaging_type` - نوع التغليف
- `$special_instructions` - تعليمات خاصة
- `$handling_requirements` - متطلبات التعامل

#### 7. **معلومات التأمين (9 متغيرات)**
- `$insurance_company` - شركة التأمين
- `$insurance_policy_number` - رقم بوليصة التأمين
- `$insurance_amount` - مبلغ التأمين
- `$insurance_start_date` - تاريخ بداية التأمين
- `$insurance_end_date` - تاريخ انتهاء التأمين
- `$insurance_coverage` - تغطية التأمين
- `$deductible_amount` - مبلغ التحمل
- `$insurance_contact` - جهة اتصال التأمين
- `$claim_procedure` - إجراءات المطالبة

#### 8. **الشروط والأحكام (9 متغيرات)**
- `$terms_and_conditions` - الشروط والأحكام
- `$liability_terms` - شروط المسؤولية
- `$cancellation_policy` - سياسة الإلغاء
- `$force_majeure` - القوة القاهرة
- `$dispute_resolution` - حل النزاعات
- `$governing_law` - القانون المطبق
- `$jurisdiction` - الاختصاص القضائي
- `$amendment_terms` - شروط التعديل
- `$termination_conditions` - شروط الإنهاء

#### 9. **معلومات إضافية (9 متغيرات)**
- `$witness_name` - اسم الشاهد
- `$witness_signature` - توقيع الشاهد
- `$notary_name` - اسم الموثق
- `$notary_seal` - ختم الموثق
- `$contract_copies` - عدد نسخ العقد
- `$attachments` - المرفقات
- `$notes` - ملاحظات
- `$reference_number` - رقم المرجع
- `$approval_date` - تاريخ الموافقة

### 📤 **نظام تصدير متقدم**
- **تصدير PHP**: ملف PHP كامل مع كود جاهز للاستخدام
- **تصدير HTML**: ملف HTML منسق للعرض والطباعة
- **تصدير PDF**: طباعة مباشرة أو حفظ كـ PDF
- **تصدير JSON**: حفظ البيانات بتنسيق JSON

### 💾 **إدارة المحتوى**
- حفظ وفتح الملفات
- نظام التراجع والإعادة (Undo/Redo)
- حفظ تلقائي كل 30 ثانية
- معاينة العقد قبل التصدير

### 🔍 **أدوات مساعدة**
- بحث في المتغيرات
- تصنيف المتغيرات والعناصر
- اختصارات لوحة المفاتيح
- رسائل تأكيد ونجاح

---

## 🚀 **كيفية الاستخدام**

### 1. **التشغيل المحلي**
```bash
# فتح مجلد المشروع
cd contract_editor_final

# تشغيل خادم محلي
python3 -m http.server 8080

# فتح المتصفح على
http://localhost:8080
```

### 2. **رفع على خادم ويب**
- رفع جميع ملفات المشروع إلى خادم الويب
- التأكد من دعم الخادم لملفات HTML/CSS/JS
- فتح index.html في المتصفح

### 3. **البدء في التصميم**
1. اختر "عقد جديد" أو استخدم القالب الموجود
2. اسحب المتغيرات من الشريط الجانبي إلى المحرر
3. أضف العناصر المطلوبة (جداول، توقيعات، إلخ)
4. خصص المحتوى حسب احتياجاتك
5. احفظ العقد أو صدره بالتنسيق المطلوب

---

## 🎯 **اختصارات لوحة المفاتيح**

| الاختصار | الوظيفة |
|---------|---------|
| `Ctrl + N` | عقد جديد |
| `Ctrl + O` | فتح عقد |
| `Ctrl + S` | حفظ العقد |
| `Ctrl + Z` | تراجع |
| `Ctrl + Y` | إعادة |
| `Ctrl + P` | معاينة |
| `Ctrl + E` | تصدير |

---

## 📁 **هيكل المشروع**

```
contract_editor_final/
├── index.html          # الصفحة الرئيسية
├── css/
│   └── style.css       # ملف الأنماط الشامل
├── js/
│   └── script.js       # ملف JavaScript الرئيسي
├── images/             # مجلد الصور (فارغ)
├── README.md           # دليل المستخدم
├── FEATURES.md         # دليل الميزات المفصل
└── test_results.md     # تقرير الاختبار
```

---

## 🔧 **المتطلبات التقنية**

### **متطلبات الخادم**
- خادم ويب يدعم HTML/CSS/JavaScript
- لا يتطلب قاعدة بيانات
- لا يتطلب لغات برمجة خادم

### **متطلبات المتصفح**
- متصفح حديث يدعم HTML5
- دعم JavaScript ES6+
- دعم CSS3 والمتغيرات
- دعم Drag & Drop API

### **المتصفحات المدعومة**
- ✅ Chrome 60+
- ✅ Firefox 55+
- ✅ Safari 12+
- ✅ Edge 79+

---

## 🎨 **التخصيص والتطوير**

### **تخصيص الألوان**
يمكن تعديل الألوان من خلال متغيرات CSS في بداية ملف `style.css`:

```css
:root {
    --primary-color: #2563eb;
    --secondary-color: #64748b;
    --success-color: #10b981;
    /* ... المزيد من المتغيرات */
}
```

### **إضافة متغيرات جديدة**
لإضافة متغيرات جديدة، عدل قسم المتغيرات في `index.html`:

```html
<div class="variable-item" data-variable="$new_variable" draggable="true">
    <div class="variable-code">$new_variable</div>
    <div class="variable-name">اسم المتغير الجديد</div>
</div>
```

### **تخصيص قوالب التصدير**
يمكن تعديل قوالب التصدير في ملف `script.js` في دوال التصدير المختلفة.

---

## 🐛 **استكشاف الأخطاء وإصلاحها**

### **مشاكل شائعة وحلولها**

#### **المشكلة**: الأزرار لا تعمل
**الحل**: تأكد من تحميل ملف JavaScript بشكل صحيح وعدم وجود أخطاء في وحدة التحكم.

#### **المشكلة**: المتغيرات لا تظهر
**الحل**: تحقق من هيكل HTML وتأكد من وجود العناصر بالمعرفات الصحيحة.

#### **المشكلة**: التصدير لا يعمل
**الحل**: تأكد من دعم المتصفح لـ Blob API وFile API.

#### **المشكلة**: السحب والإفلات لا يعمل
**الحل**: تحقق من دعم المتصفح لـ Drag & Drop API.

---

## 📞 **الدعم والمساعدة**

### **الحصول على المساعدة**
- راجع ملف `FEATURES.md` للحصول على تفاصيل أكثر عن الميزات
- اطلع على `test_results.md` لمعرفة نتائج الاختبارات
- تحقق من وحدة التحكم في المتصفح للأخطاء

### **الإبلاغ عن المشاكل**
عند الإبلاغ عن مشكلة، يرجى تضمين:
- نوع المتصفح والإصدار
- وصف المشكلة بالتفصيل
- خطوات إعادة إنتاج المشكلة
- رسائل الخطأ (إن وجدت)

---

## 📄 **الترخيص**

هذا المشروع مطور خصيصاً لاستخدامك الشخصي. يمكنك تعديله وتخصيصه حسب احتياجاتك.

---

## 🏆 **الخلاصة**

محرر العقود الاحترافي هو نظام متكامل وقوي لتصميم وإدارة العقود. يوفر واجهة سهلة الاستخدام مع ميزات متقدمة تجعل عملية إنشاء العقود سريعة وفعالة.

**الميزات الرئيسية:**
- ✅ 81 متغيراً شاملاً
- ✅ واجهة عربية كاملة
- ✅ تصدير متعدد التنسيقات
- ✅ محرر تفاعلي متقدم
- ✅ تصميم عصري ومتجاوب

**جاهز للاستخدام الفوري!** 🚀

